Ext.define('Override.app.Application', {
    override : 'Ext.app.Application',

    /**
     * Override moves the viewport creation till after the controller
     * init methods have been fired.
     *
     * This will also cache the Ext.application instance onto the namespace.
     *
     * *** NOTE ***
     * For PR3, will not be valid after PR3
     */
    onBeforeLaunch: function() {
        eval(this.name).application = this;
        var controllers = this.controllers,
            ln = controllers.length,
            i, controller;

        this.controllers = Ext.create('Ext.util.MixedCollection');

        this.init();

        for (i = 0; i < ln; i++) {
            controller = this.getController(controllers[i], false);
            controller.initConfig(controller.initialConfig);
            controller.init();
        }

        if (this.autoCreateViewport) {
            this.getView('Viewport').create();
        }

        this.launch.call(this.scope || this);

        this.controllers.each(function(controller) {
            // Backwards compat
            if (controller.onLaunch) {
                controller.onLaunch(this);
            } else {
                controller.launch(this);
            }
        }, this);

        this.launched = true;
        this.fireEvent('launch', this);
    }
});